/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.ds;

/**
 * This class is used to hold customLocationID-customLocation pair retrieved from the directory server.
 */
public class CustomLocationRecord
{
	private String m_ID;
	private CustomLocation m_customLoc;
	
	/**
	 * Constructor for ID and customLocation
	 * @param id a String to represent a custom location ID
	 * @param customLoc CustomLocation object
	 */
	public CustomLocationRecord(String id, CustomLocation customLoc){
		m_ID = id;
		m_customLoc = customLoc;
	}
	
	/**
	 * Gets the ID of the custom location
	 * @return String represents the ID
	 */
	public String getID(){
		return m_ID;
	}
	
	/**
	 * Gets the custom location
	 * @return CustomLocation object
	 */	
	public CustomLocation getCustomLocation(){
		return m_customLoc;
	}
}
